package unificationSolver;

public class SimpleSentenceSolutionNode extends AbstractSolutionNode {
	
	private AbstractSolutionNode child = null;

	public SimpleSentenceSolutionNode(SimpleSentence goal, RuleSet rules, SubstitutionSet parentSolution) {
		super(goal, rules, parentSolution);
	}
	

	public SubstitutionSet nextSolution() throws CloneNotSupportedException {
		SubstitutionSet solution;
		if(child != null){
			solution = child.nextSolution();
			if (solution != null)
				return solution;
		} 
		
		child = null;
		
		Rule rule;
		
		while(hasNextRule() == true){
			rule = nextRule();
			
			SimpleSentence head = rule.getHead();
			
			solution = ((SimpleSentence)getGoal()).unify(head, getParentSolution());
			if(solution != null){
				Goal tail = rule.getBody();
				if(tail == null)
					return solution;
				child = tail.getSolver(getRuleSet(), solution);
				SubstitutionSet childSolution = child.nextSolution();
				if(childSolution != null)
					return childSolution;
			}
			
		}
		
		return null;
	}

	public AbstractSolutionNode getChild() {
		return child;
	}
}
